'BascomAVR 2.0.8.1
'    57600!  - Arduino
'     - 
'  , ,  .
'   .
'
' .. , 2025.

$noramclear
$hwstack = 256
$swstack = 256
$framesize = 256                                            '
$regfile = "m328pdef.dat"
$crystal = 16000000


'  -  
Config Portd.3 = Output
Config Portd.5 = Output
Config Portd.6 = Output


'   knob
'***************************************************************************************
Config Pind.2 = Input                                       ' 
Set Portd.2                                                 '   
Config Int0 = Falling                                       '1->0
Enable Int0
On Int0 Knob


'  0 -   
'***************************************************************************************
Config Timer0 = Timer , Prescale = 1 : On Timer0 Pwms
Enable Timer0

' UART
'***************************************************************************************
$baud = 38400
Config Com1 = Dummy , Synchrone = 0 , Parity = None , Stopbits = 1 , Databits = 8 , Clockpol = 0


' 
'***************************************************************************************
Config Adc = Single , Prescaler = Auto , Reference = Internal_1.1
Enable Adc
Start Adc

Enable Interrupts                                           '  

'  
'***************************************************************************************
Dim Pwm_r As Byte                                           '   
Dim Pwm_g As Byte                                           '   
Dim Pwm_b As Byte                                           '   
Dim Pwm_count As Byte                                       '  
Dim Bright As Byte                                          ' 
Dim New_bright As Byte                                      ' 
Dim Ledbright As Byte                                       '  
Dim Tempius As Byte                                         '   
Dim Colorwhell As Word                                      '  
Dim New_colorwhell As Word                                  '   
Dim Revers_color As Byte                                    '  
Dim Revers_bright As Byte                                   '  
Dim Fire As Single                                          '      
Dim Temp_fire As Single                                     '    
Dim Rnd_fire As Byte                                        '    
Dim Step_fire As Byte                                       '    
Dim Flg_night As Byte                                       '  
Dim Effect As Byte                                          ' 
Dim Effect_day As Byte                                      ' 
Dim Effect_night As Byte                                    ' 
Dim Flg_knob As Byte                                        '  
Dim Temp_adc As Word                                        '   

Const Morn = 300                                            '    
Const Even = 150                                            '    
Const Max_effect = 16                                       '  




'=======================================================================================
'===============================  ===============================================
'=======================================================================================
'         !
Config Submode = New


' : Color() = 0...1530, Bright() = 0...255
Sub Color_whell(byval Color As Word , Byval Bright As Byte)

   Local _r As Byte , _g As Byte , _b As Byte , _temp As Word

   If Color <= 255 Then                                     ' ,  
      _r = 255 : _g = Color : _b = 0
   Elseif Color > 255 And Color <= 510 Then                 ' ,  
      _r = 510 - Color : _g = 255 : _b = 0
   Elseif Color > 510 And Color <= 765 Then                 ' ,  
      _r = 0 : _g = 255 : _b = Color - 510
   Elseif Color > 765 And Color <= 1020 Then                ' ,  
      _r = 0 : _g = 1020 - Color : _b = 255
   Elseif Color > 1020 And Color <= 1275 Then               ' ,  
      _r = Color - 1020 : _g = 0 : _b = 255
   Elseif Color > 1275 And Color <= 1530 Then               ' ,  
      _r = 255 : _g = 0 : _b = 1530 - Color
   End If

   '   
   _temp = _r * Bright
   _temp = _temp / 255
   Pwm_r = Lookup(_temp , Ledgamma)

   _temp = _g * Bright
   _temp = _temp / 255
   Pwm_g = Lookup(_temp , Ledgamma)

   _temp = _b * Bright
   _temp = _temp / 255
   Pwm_b = Lookup(_temp , Ledgamma)

End Sub



'===   
Readeeprom Effect_day , 5
If Effect_day > Max_effect Then Effect_day = 0

Readeeprom Effect_night , 6
If Effect_night > Max_effect Then Effect_night = 0

'===  
Flg_knob = 0
Flg_night = 1
New_colorwhell = 765
Fire = 13.0
Bright = 255


Do

   '=== 
   If Flg_knob = 1 Then
      If Flg_night = 0 Then
         Incr Effect_day
         If Effect_day > Max_effect Then Effect_day = 0
         Writeeeprom Effect_day , 5
      Else
         Incr Effect_night
         If Effect_night > Max_effect Then Effect_night = 0
         Writeeeprom Effect_night , 6
      End If
      '  
      Pwm_r = 255 : Pwm_g = 255 : Pwm_b = 255
      Waitms 50
      Pwm_r = 0 : Pwm_g = 0 : Pwm_b = 0
      Waitms 200
      Flg_knob = 0
   End If


   '===  
   Temp_adc = Getadc(3)
   'Print Temp_adc                                          '  

   ' 
   If Temp_adc < Even Then Flg_night = 1                    ' 
   If Temp_adc > Morn Then Flg_night = 0                    ' 
   '  
   If Flg_night = 0 Then
      Effect = Effect_day
   Else
      Effect = Effect_night
   End If


   '=== 
   If Effect = 0 Then Colorwhell = 0                        '
   If Effect = 1 Then Colorwhell = 60                       '
   If Effect = 2 Then Colorwhell = 120                      '
   If Effect = 3 Then Colorwhell = 240                      '
   If Effect = 4 Then Colorwhell = 510                      '
   If Effect = 5 Then Colorwhell = 570                      '
   If Effect = 6 Then Colorwhell = 630                      '
   If Effect = 7 Then Colorwhell = 750                      '
   If Effect = 8 Then Colorwhell = 1020                     '
   If Effect = 9 Then Colorwhell = 1290                     '
   If Effect = 10 Then Colorwhell = 1410                    '
   If Effect = 11 Then Colorwhell = 1470                    '


   '===       
   If Effect = 12 Then
      Incr Colorwhell
      If Colorwhell > 1530 Then Colorwhell = 0
      Waitms 20                                             '  
   End If

   '===        
   If Effect = 13 Then
      Decr Colorwhell
      If Colorwhell > 1530 Then Colorwhell = 1530
      Waitms 20                                             '  
   End If

   '===
   If Effect = 14 Then Gosub Effect_fire

   '===
   If Effect = 15 Then Gosub Effect_aurora

   If Effect < 14 Then Bright = 255                         '   

   If Flg_night = 1 Then
      Ledbright = Bright / 2                                '     2 
   Else
      Ledbright = Bright                                    ' 
   End If

   '===  
   If Effect = 16 Then                                      '=== 
      Pwm_r = Ledbright : Pwm_g = Ledbright : Pwm_b = Ledbright
   Else
      Call Color_whell(colorwhell , Ledbright)
   End If


Loop

End

'===== =====
'***************************************************************************************
Effect_fire:
   Incr Step_fire
   If Step_fire = 5 Then                                    ' 5 
      Step_fire = 0
      '===    
      Rnd_fire = Rnd(15)
   End If

   '===      
   Fire = Fire * 0.85
   Fire = Fire + Rnd_fire
   Colorwhell = Fire

   '===      (75...255)
   Bright = Fire * 2
   Bright = Bright + 75

   '===     (5...20 )
   Tempius = Rnd(16)
   Tempius = Tempius + 5
   Waitms Tempius

Return

'=====  =====
'***************************************************************************************
Effect_aurora:

   '  ,    
   If Colorwhell = New_colorwhell Then
      New_colorwhell = Rnd(1530)
      Tempius = Rnd(255)
      Revers_color = Tempius.0                              '  
   End If

   If Revers_color = 0 Then
      Incr Colorwhell
      If Colorwhell > 1530 Then Colorwhell = 0
   Else
      Decr Colorwhell
      If Colorwhell > 1530 Then Colorwhell = 1530
   End If

   Revers_bright = Rnd(255)
   '  
   If Revers_bright < 128 Then
      If Bright < 255 Then Incr Bright
   Else
      If Bright > 80 Then Decr Bright
   End If

   '    
   Tempius = Rnd(5)
   Waitms Tempius

Return

'=====   =====
'***************************************************************************************
Knob:
   Flg_knob = 1
Return

'=====  0   =====
'***************************************************************************************
Pwms:
   Incr Pwm_count
   If Pwm_r > Pwm_count Then Portd.5 = 1 Else Portd.5 = 0
   If Pwm_g > Pwm_count Then Portd.3 = 1 Else Portd.3 = 0
   If Pwm_b > Pwm_count Then Portd.6 = 1 Else Portd.6 = 0
Return

'===== -     =====
'***************************************************************************************
Ledgamma:
   Data 0 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1
   Data 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 2 , 2 , 2
   Data 2 , 2 , 2 , 3 , 3 , 3 , 3 , 3 , 4 , 4 , 4 , 4 , 5 , 5 , 5 , 5
   Data 6 , 6 , 6 , 7 , 7 , 7 , 8 , 8 , 8 , 9 , 9 , 9 , 10 , 10 , 11 , 11
   Data 11 , 12 , 12 , 13 , 13 , 13 , 14 , 14 , 15 , 15 , 16 , 16 , 17 , 17 , 18 , 18
   Data 19 , 19 , 20 , 21 , 21 , 22 , 22 , 23 , 23 , 24 , 25 , 25 , 26 , 27 , 27 , 28
   Data 29 , 29 , 30 , 31 , 31 , 32 , 33 , 34 , 34 , 35 , 36 , 37 , 37 , 38 , 39 , 40
   Data 40 , 41 , 42 , 43 , 44 , 45 , 46 , 46 , 47 , 48 , 49 , 50 , 51 , 52 , 53 , 54
   Data 55 , 56 , 57 , 58 , 59 , 60 , 61 , 62 , 63 , 64 , 65 , 66 , 67 , 68 , 69 , 70
   Data 71 , 72 , 73 , 74 , 76 , 77 , 78 , 79 , 80 , 81 , 83 , 84 , 85 , 86 , 88 , 89
   Data 90 , 91 , 93 , 94 , 95 , 96 , 98 , 99 , 100 , 102 , 103 , 104 , 106 , 107 , 109 , 110
   Data 111 , 113 , 114 , 116 , 117 , 119 , 120 , 121 , 123 , 124 , 126 , 128 , 129 , 131 , 132 , 134
   Data 135 , 137 , 138 , 140 , 142 , 143 , 145 , 146 , 148 , 150 , 151 , 153 , 155 , 157 , 158 , 160
   Data 162 , 163 , 165 , 167 , 169 , 170 , 172 , 174 , 176 , 178 , 179 , 181 , 183 , 185 , 187 , 189
   Data 191 , 193 , 194 , 196 , 198 , 200 , 202 , 204 , 206 , 208 , 210 , 212 , 214 , 216 , 218 , 220
   Data 222 , 224 , 227 , 229 , 231 , 233 , 235 , 237 , 239 , 241 , 244 , 246 , 248 , 250 , 252 , 255